/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.casting.arithmetic;

import at.petrak.hexcasting.api.casting.arithmetic.Arithmetic;
import at.petrak.hexcasting.api.casting.arithmetic.engine.InvalidOperatorException;
import at.petrak.hexcasting.api.casting.arithmetic.operator.Operator;
import at.petrak.hexcasting.api.casting.arithmetic.operator.OperatorUnary;
import at.petrak.hexcasting.api.casting.arithmetic.predicates.IotaMultiPredicate;
import at.petrak.hexcasting.api.casting.arithmetic.predicates.IotaPredicate;
import at.petrak.hexcasting.api.casting.iota.DoubleIota;
import at.petrak.hexcasting.api.casting.iota.Vec3Iota;
import at.petrak.hexcasting.api.casting.math.HexPattern;
import at.petrak.hexcasting.common.casting.arithmetic.operator.vec.OperatorPack;
import at.petrak.hexcasting.common.casting.arithmetic.operator.vec.OperatorUnpack;
import at.petrak.hexcasting.common.casting.arithmetic.operator.vec.OperatorVec3Delegating;
import at.petrak.hexcasting.common.lib.hex.HexIotaTypes;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.class_243;

public enum Vec3Arithmetic implements Arithmetic
{
    INSTANCE;

    public static final List<HexPattern> OPS;
    public static final IotaMultiPredicate ACCEPTS;

    @Override
    public String arithName() {
        return "vec3_math";
    }

    @Override
    public Iterable<HexPattern> opTypes() {
        return OPS;
    }

    @Override
    public Operator getOperator(HexPattern pattern) {
        if (pattern.equals(PACK)) {
            return OperatorPack.INSTANCE;
        }
        if (pattern.equals(UNPACK)) {
            return OperatorUnpack.INSTANCE;
        }
        if (pattern.equals(ADD)) {
            return Vec3Arithmetic.make2Fallback(pattern);
        }
        if (pattern.equals(SUB)) {
            return Vec3Arithmetic.make2Fallback(pattern);
        }
        if (pattern.equals(MUL)) {
            return Vec3Arithmetic.make2Double(pattern, class_243::method_1026);
        }
        if (pattern.equals(DIV)) {
            return Vec3Arithmetic.make2Vec(pattern, class_243::method_1036);
        }
        if (pattern.equals(ABS)) {
            return Vec3Arithmetic.make1Double(class_243::method_1033);
        }
        if (pattern.equals(POW)) {
            return Vec3Arithmetic.make2Vec(pattern, (u, v) -> v.method_1029().method_1021(u.method_1026(v.method_1029())));
        }
        if (pattern.equals(FLOOR)) {
            return Vec3Arithmetic.make1(v -> new class_243(Math.floor(v.field_1352), Math.floor(v.field_1351), Math.floor(v.field_1350)));
        }
        if (pattern.equals(CEIL)) {
            return Vec3Arithmetic.make1(v -> new class_243(Math.ceil(v.field_1352), Math.ceil(v.field_1351), Math.ceil(v.field_1350)));
        }
        if (pattern.equals(MOD)) {
            return Vec3Arithmetic.make2Fallback(pattern);
        }
        throw new InvalidOperatorException(pattern + " is not a valid operator in Arithmetic " + this + ".");
    }

    public static OperatorUnary make1(Function<class_243, class_243> op) {
        return new OperatorUnary(ACCEPTS, i -> new Vec3Iota((class_243)op.apply(Operator.downcast(i, HexIotaTypes.VEC3).getVec3())));
    }

    public static OperatorUnary make1Double(Function<class_243, Double> op) {
        return new OperatorUnary(ACCEPTS, i -> new DoubleIota((Double)op.apply(Operator.downcast(i, HexIotaTypes.VEC3).getVec3())));
    }

    public static OperatorVec3Delegating make2Fallback(HexPattern pattern) {
        return new OperatorVec3Delegating(null, pattern);
    }

    public static OperatorVec3Delegating make2Double(HexPattern pattern, BiFunction<class_243, class_243, Double> op) {
        return new OperatorVec3Delegating(op.andThen(DoubleIota::new), pattern);
    }

    public static OperatorVec3Delegating make2Vec(HexPattern pattern, BiFunction<class_243, class_243, class_243> op) {
        return new OperatorVec3Delegating(op.andThen(Vec3Iota::new), pattern);
    }

    static {
        OPS = List.of(PACK, UNPACK, ADD, SUB, MUL, DIV, ABS, POW, FLOOR, CEIL, MOD);
        ACCEPTS = IotaMultiPredicate.any(IotaPredicate.ofType(HexIotaTypes.VEC3), IotaPredicate.ofType(HexIotaTypes.DOUBLE));
    }
}

